package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.TaskAging;

public interface PersonTaskDAO {

	void save(final PersonTask personTask);
	void delete(final PersonTask personTask);
	PersonTask findById(final int taskId);
	List<PersonTask> listByOwner(final int ownerId);
	List<PersonTask> listOpenByOwner(final int ownerId);
	List<PersonTask> listOpenByRequestId(final int requestId);
	List<PersonTask> listOpenByWorkflowAndRequestId(final int workflowId, final int requestId);
	TaskAging getTaskAging(final int ownerId);
	List<PersonTask> listAllPersonTasks();
	List<PersonTask> listAllOpenPersonTasks();
}
